#include <stdio.h>
#include <stdlib.h>

#define MAKS_N 200005

int NizA[MAKS_N];
int br[MAKS_N];
int zpoz[MAKS_N];

typedef struct {
    long long v;
    int id;
} Stavka;

Stavka m[MAKS_N];
int ms = 0;

void Ubaci(long long tezina, int id) {
    int i = ms++;
    while (i > 0) {
        int roditelj = (i - 1) / 2;
        if (m[roditelj].v >= tezina) break;
        m[i] = m[roditelj];
        i = roditelj;
    }
    m[i].v = tezina;
    m[i].id = id;
}

Stavka Izbaci() {
    Stavka rezultat = m[0];
    Stavka x = m[--ms];
    
    int i = 0;
    while (i * 2 + 1 < ms) {
        int levo = i * 2 + 1;
        int desno = i * 2 + 2;
        int najveci = levo;
        
        if (desno < ms && m[desno].v > m[levo].v) {
            najveci = desno;
        }
        
        if (m[najveci].v <= x.v) break;
        
        m[i] = m[najveci];
        i = najveci;
    }
    m[i] = x;
    return rezultat;
}

int glava[MAKS_N]; 
int sledeci[MAKS_N]; 
int vr_cvora[MAKS_N]; 

int main() {
    int N, Q;
    if (scanf("%d %d", &N, &Q) != 2) return 1;

    for (int i = 1; i <= N; i++) {
        scanf("%d", &NizA[i]);
    }

    for (int q = 0; q < Q; q++) {
        int tip;
        scanf("%d", &tip);

        if (tip == 1) {
            int k;
            scanf("%d", &k);

            for (int i = 0; i <= N; i++) {
                br[i] = 0;
                zpoz[i] = 0;
                glava[i] = -1;
            }

            long long ukupna_suma = 0;

            for (int i = 1; i <= N; i++) {
                int vrednost = NizA[i];
                br[vrednost]++;
                zpoz[vrednost] = i;
                ukupna_suma += vrednost;
            }

            for (int i = 1; i <= N; i++) {
                if (br[i] > 0) {
                    int pos = zpoz[i];
                    sledeci[i] = glava[pos];
                    vr_cvora[i] = i;
                    glava[pos] = i;
                }
            }

            ms = 0;
            long long uklonjena_suma = 0;

            for (int t = 1; t <= N; t++) {
                int trenutni = glava[t];
                while (trenutni != -1) {
                    int id_karte = vr_cvora[trenutni];
                    long long tezina = (long long)id_karte * br[id_karte];
                    Ubaci(tezina, id_karte);
                    trenutni = sledeci[trenutni];
                }

                if (t > k) {
                    if (ms > 0) {
                        Stavka najbolji = Izbaci();
                        uklonjena_suma += najbolji.v;
                    }
                }
            }
            
            printf("%lld\n", ukupna_suma - uklonjena_suma);

        } else if (tip == 2) {
            int indeks, nova_vrednost;
            scanf("%d %d", &indeks, &nova_vrednost);
            NizA[indeks] = nova_vrednost;
        }
    }

    return 0;
}